//
//  HNSSyntaxAwareTextView.m
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Fri Jun 21 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import "HNSAppKit/HNSSyntaxAwareTextView.h"

// extend with syntax highlighting methods

@implementation HNSSyntaxAwareTextView

// - (id)initWithFrame:(NSRect)frameRect textContainer:(NSTextContainer *)aTextContainer
// {
// }

- (void) dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[super dealloc];
}

- (void) setKeywordDictionary:(NSDictionary *) dict;
{
	[keywords autorelease];
	keywords=[dict retain];
#if 0
	NSLog(@"keyword dictionary=%@", keywords);
#endif
}

- (void) setKeywordResourceFile:(NSString *) path;
{
	[self setKeywordDictionary:[NSDictionary dictionaryWithContentsOfFile:path]];
}

- (NSDictionary *) keywordDictionary;
{
	return keywords;
}

- (void) highlightSyntax
{
	unsigned int line;		// line number
	unsigned int indent;	// current indentation level
	unsigned int i0;		// starting scanLocation of current keyword/symbol/string/comment
	unsigned int l0;		// starting scanLocation of current line
	BOOL needsindent;		// line needs indentation
	NSColor *c;				// color to be set
	NSString *s;			// used for decoding [keywords objectForKey:Keywords_KEYWORDS]
	double d;				// used to recognize floating point constants
	NSScanner *sc=[NSScanner scannerWithString:[self string]];
	NSRange sel=[self selectedRange];	// save
#define setSelStart(x) sel.length=((sel.location+sel.length)>(x)?(sel.location+sel.length-(x)):0); sel.location=(x)
#define setSelEnd(x) sel.length=((x)>sel.location?((x)-sel.location):0); sel.location=(x)-sel.length
#if 0
	NSLog(@"sel=%@", NSStringFromRange(sel));
#endif
	[sc setCharactersToBeSkipped:nil];
	indent=0;
	l0=[sc scanLocation];
	[sc scanCharactersFromSet:[NSCharacterSet whitespaceCharacterSet] intoString:nil];	// skip all white spaces of first line
	needsindent=YES;	// and check
	line=0;
	while(![sc isAtEnd])
		{
		i0=[sc scanLocation];
		c=[NSColor blackColor];	// default
		s=nil;
		if([sc scanString:@"\n" intoString:nil])
			{ // next line starts
			l0=[sc scanLocation];
			[sc scanCharactersFromSet:[NSCharacterSet whitespaceCharacterSet] intoString:nil];	// skip all white spaces
			needsindent=YES;	// and check
			line++;
			if(line == 1)
				{ // check selection start
				if(sel.location < l0)
					{ // trim selection to start after first line
					setSelStart(l0);
#if 0
					NSLog(@"trim 1st. line to %@", NSStringFromRange(sel));
#endif
					}
				}
			continue;			// and handle next/first keyword
			// what about empty lines???
			}
		else if([sc scanString:@"\"" intoString:nil])
			{ // scan string constant
			[sc scanUpToString:@"\"" intoString:nil];	// may end up at end of string
			// should process escapes!!!
			[sc scanString:@"\"" intoString:nil];		// and eat closing "
			c=[NSColor purpleColor];
			}
		else if([sc scanString:@"'" intoString:nil] || [sc scanString:@"//" intoString:nil])
			{ // comment
			[sc scanUpToString:@"\n" intoString:nil];	// to end of line
			c=[NSColor redColor];
			}
		else if([sc scanDouble:&d])
			{ // integer or float constant
			c=[NSColor greenColor];
			}
// handle &h, &o, &b hex/octal/binary constants
		else if([sc scanCharactersFromSet:[NSCharacterSet
characterSetWithCharactersInString:[keywords objectForKey:Keywords_SYMBOLICAL]] intoString:&s])
			{ // symbol
			if([[keywords objectForKey:Keywords_KEYWORDS] objectForKey:[s lowercaseString]])
				c=[NSColor blueColor];		// reserved keyword
			// process only if s is first in this line!!!
			if(needsindent && [[keywords objectForKey:Keywords_LESSINDENT] objectForKey:[s lowercaseString]] && indent > 0)
				indent--;	// indent this line one less
			}
		else
			[sc setScanLocation:i0+1];	// handle single character
		[self setTextColor:c range:NSMakeRange(i0, [sc scanLocation]-i0)];	// apply (new) color to scanned part
		if(needsindent)
			{
			int lin=2*indent;
			NSString *in=[@"" stringByPaddingToLength:lin withString: @"  " startingAtIndex:0];	// indent string
#if 0
			NSLog(@"line %d: i0=%d location=%d delta=%d", line, i0, sel.location, lin-(i0-l0));
#endif
			if(line != 1 && sel.length == 0 && i0 == sel.location && lin == (i0-l0)+1)
				{ // join lines (but not second with first)!
#if 0
				NSLog(@"join lines");
#endif
				l0--;	// include \n in replacement
				in=@"";	// replace with nothing
				lin=-1;	// enforce
				}
			if((i0-l0) != lin)
				{ // re-indent line as specified
				[self replaceCharactersInRange:NSMakeRange(l0, i0-l0) withString:in];		// replace
				i0=l0+lin;	// new location of first keyword
				sc=[NSScanner scannerWithString:[self string]];	// needs to set up new scanner!
				[sc setCharactersToBeSkipped:nil];
				[sc setScanLocation:l0];	// rescan from beginning of line
				}
#if 0
			NSLog(@"sel=%@, lstart=%d, kwstart=%d", NSStringFromRange(sel), l0, i0);
#endif
			if(sel.location >= l0 && sel.location <i0)
				{ // selection starts between l0 and i0 -> set to new i0
				// should do +1 only if in called in response to a character insertion!!!
				setSelStart(i0+1);	// starts within blank range - trim forward behind first nonblank character (after indent)
#if 0
				NSLog(@"trim beginning to %@", NSStringFromRange(sel));
#endif
				}
			if(sel.location+sel.length >= l0 && sel.location+sel.length <i0)
				{ // if selection ends between l0 and i0 -> set to end at l0-1
				setSelEnd(l0-1);	// ends within blank range - trim back to end of previous line
#if 0
				NSLog(@"trim end to %@", NSStringFromRange(sel));
#endif
				}
			}
		if(needsindent && s != nil && [[keywords objectForKey:Keywords_MOREINDENT] objectForKey:[s lowercaseString]]) // if keyword in [keywords objectForKey:Keywords_MOREINDENT]
			indent++;	// indent next line one more
		needsindent=NO;	// only once per line
		}
	// if selection ends after l0 (i.e. start of last line)
	// set end to l0-1
#if 0
	NSLog(@"sel:=%@", NSStringFromRange(sel));
#endif
	[self setSelectedRange:sel];	// restore
}

- (IBAction) commentLines:(id) Sender
{
	// check all selected lines
	// if all are comments -> uncomment
	// else add comment if not already there
//	[self setSelectedRange:NSMakeRange(3, 11)];
	// add/remove comments in selected line(s)
	NSLog(@"commentLines not implemented");
	[self highlightSyntax];
}

- (IBAction) insertTemplate:(id) Sender
{
	NSArray *template;
	NSString *t;
	int i=[Sender tag];
	template=[[keywords objectForKey:Keywords_TEMPLATE] retain];	// get entry from keyword ressource
	if(i<0 || i>=[template count])
		return;	// just ignore
	t=[template objectAtIndex:i];
#if 0
	NSLog(@"insert: %@", t);
#endif
	[self replaceCharactersInRange:[self selectedRange] withString:t];
	[self highlightSyntax];	// and highlight
}

- (IBAction) scrollSelection:(id) Sender
{
}

- (IBAction) findsel:(id) Sender
{
}

- (IBAction) findprev:(id) Sender
{
}

- (IBAction) findnext:(id) Sender
{
}

- (void) didChange:(id) notification
{
#if 0
	NSLog(@"NSTextDidChangeNotification: %@", notification);
#endif
	[self highlightSyntax];	// apply syntax highlight rules
}

- (void) autoHighlight:(BOOL) flag
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	if(flag)
		[[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(didChange:) name:NSTextDidChangeNotification object:self];
}

@end
